#
# Extensible User Folder
# 
# User Supplied Property Source for exUserFolder
#
from Globals import HTMLFile, MessageDialog, INSTANCE_HOME
import Acquisition

from OFS.Folder import Folder

from ZODB.PersistentMapping import PersistentMapping
from Products.ZSQLMethods.SQL import SQL

from Products.exUserFolder.exUserFolder import exUserFolder
from Products.exUserFolder.Plugins import PluginRegister

from Persistence import Persistent

manage_addPropSourceForm=HTMLFile('manage_addusPropSourceForm', globals())

import cPickle


def manage_addusPropSource(self, REQUEST):
	""" Add a User-supplied Prop Source """

	o = usPropSource()
	self._setObject('usPropSource', o, None, None, 0)
	o = getattr(self, 'usPropSource')

	# Allow Prop Source to setup default users...
	if hasattr(o, 'postInitialisation'):
		o.postInitialisation(REQUEST)
	self.currentPropSource=o
	return ''

manage_addusPropSourceForm=HTMLFile('manage_addusPropSourceForm', globals())
manage_editusPropSourceForm=HTMLFile('manage_editusPropSourceForm', globals())

#
# Very simple thing
#
class usPropSource(Folder):
	""" Store Properties using a User Supplied Set of Methods """

	meta_type='Property Source'
	title='User Supplied Properties'
	icon ='misc_/exUserFolder/exUserFolderPlugin.gif'
	#manage_tabs=Acquisition.Acquired
	manage_editForm=manage_editusPropSourceForm
	dict=PersistentMapping()
	
	def __init__(self):
		self.id='usPropSource'

		
	def hasProperty(self, key):
		if 'usHasProperty' in self.objectIds():
			return self.usHasProperty(key)

	def delProperty(self, key):
		if 'usDelProperty' in self.objectIds():
			return self.usDelProperty(key)

	def delUserProperty(self, key, username):
		if 'usDelUserProperty' in self.objectIds():
			return self.usDelUserProperty(key, username)

	def flushTempProperties(self):
		if 'usFlushTempProperties' in self.objectIds():
			return self.usFlushTempProperties()
		
	def setProperty(self, key, value):
		if 'usSetProperty' in self.objectIds():
			return self.usSetProperty(key, value)

	def setTempProperty(self, key, value):
		if 'usSetTempProperty' in self.objectIds():
			return self.usSetTempProperty(key, value)
		
	def setUserProperty(self, key, username, value, temp=0):
		if 'usSetUserProperty' in self.objectIds():
			return self.usSetUserProperty(key, username, value, temp)

	def getUserProperty(self, key, username, default=None):
		if 'usGetUserProperty' in self.objectIds():
			return self.usGetUserProperty(key, username, default)
		
	def getProperty(self, key, default=None):
		if 'usGetProperty' in self.objectIds():
			return self.usGetProperty(key, default)
	
	def loadProperties(self):
		if 'usLoadProperties' in self.objectIds():
			return self.usLoadProperties()

	def loadUserProperties(self, username):
		if 'usLoadUserProperties' in self.objectIds():
			return self.usLoadUserProperties(username)

	def listProperties(self):
		if 'usListProperties' in self.objectIds():
			return self.usListProperties()
		
	def listUserProperties(self, username):
		if 'usListUserProperties' in self.objectIds():
			return self.usListUserProperties(username)
		
	def createUser(self, username, REQUEST):
		if 'usCreateUser' in self.objectIds():
			props = {}
			for k in REQUEST.keys():
				if k[:5]=='user_':
					key=k[5:]
					value=REQUEST[k]
					props[key] = value
			return self.usCreateUser(username, props)

	def deleteUsers(self, userids):
		if 'usDeleteUsers' in self.objectIds():
			return self.usDeleteUsers(userids)

	def updateUser(self, username, REQUEST):
		if 'usUpdateUser' in self.objectIds():
			props = {}
			for k in REQUEST.keys():
				if k[:5]=='user_':
					key=k[5:]
					value=REQUEST[k]
					props[key] = value
			return self.usUpdateUser(username, props)

	def __setstate__(self, state):
		Persistent.__setstate__(self, state)


	def postInitialisation(self, REQUEST):
		pass

usPropReg=PluginRegister('usPropSource', 'User Supplied Properties Source',
						 usPropSource, manage_addusPropSourceForm,
						 manage_addusPropSource,
						 manage_editusPropSourceForm)

exUserFolder.propSources['usPropSource']=usPropReg

